<?php
/**
 * Plugin Name: Bytflow Elements for Bricks
 * Description: Custom elements for Bricks Builder — Decimal Counter and more.
 * Version: 1.0.0
 * Author: Bytflow
 * Author URI: https://bytflow.com
 * Text Domain: bytflow-bricks
 * Requires PHP: 7.4
 * Requires at least: 6.0
 */

use Bricks\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

const BYTFLOW_BRICKS_VERSION = '1.0.0';
define( 'BYTFLOW_BRICKS_PATH', plugin_dir_path( __FILE__ ) );
define( 'BYTFLOW_BRICKS_URL', plugin_dir_url( __FILE__ ) );

/**
 * Admin notice if Bricks theme is not active.
 */
add_action( 'admin_notices', function () {
	if ( defined( 'BRICKS_VERSION' ) ) {
		return;
	}

	echo '<div class="notice notice-warning"><p>';
	echo esc_html__( 'Bytflow Elements for Bricks requires the Bricks Builder theme to be active.', 'bytflow-bricks' );
	echo '</p></div>';
} );

/**
 * Register all elements via auto-discovery.
 *
 * Scans elements/{name}/element.php and registers each with Bricks.
 */
add_action( 'init', function () {
	if ( ! defined( 'BRICKS_VERSION' ) ) {
		return;
	}

	$element_files = glob( BYTFLOW_BRICKS_PATH . 'elements/*/element.php' );

	if ( $element_files ) {
		foreach ( $element_files as $element_file ) {
			Elements::register_element( $element_file );
		}
	}
}, 11 );

/**
 * Custom category label for Bytflow elements.
 */
add_filter( 'bricks/builder/i18n', function ( $i18n ) {
	$i18n['bytflow'] = esc_html__( 'Bytflow', 'bytflow-bricks' );
	return $i18n;
} );
