<?php
/**
 * Plugin Name: Bricks Editor Form Delete
 * Description: Allows Editors to delete Bricks form submissions safely.
 * Version: 1.0.0
 * Author: Ivo Jerković
 * Author URI: https://ivojerkovic.com/
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_filter( 'map_meta_cap', function ( $caps, $cap, $user_id ) {

    if ( $cap !== 'manage_options' ) {
        return $caps;
    }

    if ( ! is_admin() ) {
        return $caps;
    }

    $user = get_userdata( $user_id );
    if ( ! $user || ! user_can( $user, 'edit_others_posts' ) ) {
        return $caps;
    }

    $page = isset( $_REQUEST['page'] )
        ? sanitize_key( wp_unslash( $_REQUEST['page'] ) )
        : '';

    $action = isset( $_REQUEST['action'] )
        ? sanitize_key( wp_unslash( $_REQUEST['action'] ) )
        : '';

    /*
    |--------------------------------------------------------------------------
    | 1. Allow UI rendering on submissions screen (GET)
    |--------------------------------------------------------------------------
    */

    if (
        $_SERVER['REQUEST_METHOD'] === 'GET' &&
        $page === 'bricks-form-submissions'
    ) {
        return array( 'exist' );
    }

    /*
    |--------------------------------------------------------------------------
    | 2. Allow actual delete action (POST)
    |   Nonce is already verified by WP_List_Table (action: bulk-submissions)
    |   and again inside Bricks handle_custom_actions().
    |--------------------------------------------------------------------------
    */

    if (
        $_SERVER['REQUEST_METHOD'] === 'POST' &&
        $page === 'bricks-form-submissions' &&
        $action === 'bricks_delete_form_entries'
    ) {
        return array( 'exist' );
    }

    /*
    |--------------------------------------------------------------------------
    | 3. Allow AJAX "delete all entries by form ID" button (POST)
    |   Nonce (bricks-nonce-admin) verified by Bricks Ajax::verify_nonce().
    |   Also requires bricks_form_submission_access capability.
    |--------------------------------------------------------------------------
    */

    if (
        $_SERVER['REQUEST_METHOD'] === 'POST' &&
        $action === 'bricks_form_submissions_delete_form_id'
    ) {
        return array( 'exist' );
    }

    return $caps;

}, 10, 3 );
